﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business;
using VHAReportViewer;

public partial class LabResultsInterpretationLetters : BasePage
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/BioLabInterpretation.aspx",
        "/FragLabInterpretation.aspx",
        "/FragLabInterpretationFragment.aspx",
        "/PatientWorkflows.aspx"
    };

    private UserAccountManager _currentUser;

    private readonly ReportViewerHandler _reportViewerHandler;

    public LabResultsInterpretationLetters()
    {
        _reportViewerHandler = new ReportViewerHandler();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        string activityID = Request.QueryString["activityId"].ToString();
        string intActivityID = Request.QueryString["intActivityId"].ToString();
        string ReportType = Request.QueryString["RptType"].ToString();
        bool batchReport = (activityID == "0");
        int caseId = Helpers.getIntFromString(Request.QueryString["CaseId"]);

        if (!Page.IsPostBack)
        {
            // Set print options for JS
            Session["batchReport"] = SessionItemFactory.Create(batchReport.ToString());
            Session["EFRBatchPrintOptions"] = SessionItemFactory.Create(Helpers.getCrsSetting("EFRBatchPrintOptions"));
            Session["EFRIndividualPrintOptions"] = SessionItemFactory.Create(Helpers.getCrsSetting("EFRIndividualPrintOptions"));

            ClientScript.RegisterStartupScript(this.GetType(), "LoadPrintOptions", "window.onload=loadReportPrintOptions();");

            if (batchReport)
            {

                switch (ReportType)
                {
                    case "11":
                        BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > New > Print Completed Patient Letters - Biological Monitoring";
                        break;
                    case "12":
                        BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > New > Print Completed Provider Letters - Biological Monitoring";
                        break;
                    case "13":
                        BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > New > Print Completed Patient Letters - Fragment Analysis";
                        break;
                    case "14":
                        BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > New > Print Completed Provider Letters - Fragment Analysis";
                        break;
                }
                Session["PrintCompletedLetters"] = true;
            }
            else
            {
                LabResultsIntrprtnManager LabIntrptnMgr = new LabResultsIntrprtnManager();
                WKF_CASE WCase = LabIntrptnMgr.GetLabInterpretationDetails(caseId); ;

                HiddenFieldCaseTypeID.Value = WCase.STD_WKFCASETYPE_ID.ToString();
                // 3 = Bio
                // 4 = Fragment

                STD_WKFACTIVITYST ActivitySt;

                WKF_CASE_ACTIVITY intActivity = WCase.WKF_CASE_ACTIVITies.Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation)).Select(t => t).FirstOrDefault();

                // If this is called by unaccepting lab results, and while they are unaccepted, clicking on the 'Patient/Provider Interpretation letter Archived'
                // there will be an error because there are no 'Interpretion' wkf_case_activity entries in Intepreted status. Try again w/o that restriction

                if (intActivity != null)
                {
                    ActivitySt = intActivity.STD_WKFACTIVITYST;

                    BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > " + ActivitySt.NAME + " > Workflow ID " + WCase.WKF_CASE_ID;
                }
                else
                {
                    // Assume "In Progress"
                    BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > " + "In Process" + " > Workflow ID " + WCase.WKF_CASE_ID;
                }

                if (ReportType == "0") //Patient
                    BreadCrumbLabel.Text = BreadCrumbLabel.Text + " > Patient Letter";
                if (ReportType == "1") //Provider
                    BreadCrumbLabel.Text = BreadCrumbLabel.Text + " > Provider Letter";
            }

            SetReferringPage();
        }


        ReportViewer1.Visible = false;

        ReportViewer1.Reset();

        _reportViewerHandler.ClearParams();
        if (!batchReport)
        {
            _reportViewerHandler.AddReportVariable("activityId", activityID);
            _reportViewerHandler.AddReportVariable("intActivityId", intActivityID);
            _reportViewerHandler.AddReportVariable("reportType", ReportType);
        }

        if (batchReport)
        {
            ReportViewer1.ServerReport.ReportPath = "InterpretationLettersMaster";
            switch (ReportType)
            {
                case "11":
                    ReportViewer1.ServerReport.ReportPath = "PatientBioLabIntrprtnLetterBatch";
                    break;
                case "12":
                    ReportViewer1.ServerReport.ReportPath = "ProviderLabIntrprtnLetterBatch";
                    break;
                case "13":
                    ReportViewer1.ServerReport.ReportPath = "PatientFragAnlyLabIntrprtnLetterBatch";
                    break;
                case "14":
                    ReportViewer1.ServerReport.ReportPath = "ProviderFragAnlyLabIntrprtnLetterBatch";
                    break;
            }
        }
        //Bio Monitoring
        else if (Int32.Parse(HiddenFieldCaseTypeID.Value) == 3)
        {
            if (ReportType == "0") //Patient
                ReportViewer1.ServerReport.ReportPath = "PatientBioLabIntrprtnLetter";
            if (ReportType == "1") //Provider
                ReportViewer1.ServerReport.ReportPath = "ProviderLabIntrprtnLetter";
        }
        //Fragment Analysis
        else if (Int32.Parse(HiddenFieldCaseTypeID.Value) == 4)
        {
            if (ReportType == "0") //Patient
                ReportViewer1.ServerReport.ReportPath = "PatientFragAnlyLabIntrprtnLetter";
            if (ReportType == "1") //Provider
                ReportViewer1.ServerReport.ReportPath = "ProviderFragAnlyLabIntrprtnLetter";
        }

        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        {
            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
        }

        _reportViewerHandler.SetServerReportParameters(ReportViewer1);

        ReportViewer1.ProcessingMode = ProcessingMode.Remote;
        ReportViewer1.ServerReport.Refresh();
        ReportViewer1.Visible = true;
    }


    protected void Cancel_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();

    }
    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "EFR_LABINTERPRETATION";
    }

    public override string AppObjectCode()
    {
        return "EFR_LABINTERPRETATION";
    }

}
